/**
 * 
 */
package gov.va.med.mhv.bluebutton.converter;

import gov.va.med.mhv.bluebutton.model.StudyJob;
import gov.va.med.mhv.bluebutton.transfer.StudyJobDTO;

import java.text.DecimalFormat;

import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

@Component
public class StudyJobConverter implements Converter<StudyJob, StudyJobDTO> {

	@Override
	public StudyJobDTO convert(StudyJob source) {
		StudyJobDTO d = new StudyJobDTO();
		d.setStatus(source.getStatus());
		d.setStatusText(source.getStatusText());
		d.setStudyIdUrn(source.getStudyIdUrn());
		d.setFileSize(formatFileSize(source.getFileSize()));
		d.setFileSizeNumber(source.getFileSize());
		d.setEndDate(source.getEndDate());
		d.setStartDate(source.getStartDate());
		return d;
	}
	
	public static String formatFileSize(Long size) {
		if(size==null) {return "";}
		
	    String hrSize = null;

	    double b = size;
	    double k = size/1024.0;
	    double m = ((size/1024.0)/1024.0);
	    double g = (((size/1024.0)/1024.0)/1024.0);
	    double t = ((((size/1024.0)/1024.0)/1024.0)/1024.0);

	    DecimalFormat dec = new DecimalFormat("0.00");

	    if ( t>1 ) {
	        hrSize = dec.format(t).concat(" TB");
	    } else if ( g>1 ) {
	        hrSize = dec.format(g).concat(" GB");
	    } else if ( m>1 ) {
	        hrSize = dec.format(m).concat(" MB");
	    } else if ( k>1 ) {
	        hrSize = dec.format(k).concat(" KB");
	    } else {
	        hrSize = dec.format(b).concat(" Bytes");
	    }

	    return hrSize;
	}

}
